package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountUsage(
    totalCodeSize: Optional[Long] = Optional.Absent,
    functionCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AccountUsage = {
    import AccountUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AccountUsage
      .builder()
      .optionallyWith(totalCodeSize.map(value => value: java.lang.Long))(
        _.totalCodeSize
      )
      .optionallyWith(functionCount.map(value => value: java.lang.Long))(
        _.functionCount
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AccountUsage.ReadOnly =
    zio.aws.lambda.model.AccountUsage.wrap(buildAwsValue())
}
object AccountUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AccountUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AccountUsage =
      zio.aws.lambda.model.AccountUsage(
        totalCodeSize.map(value => value),
        functionCount.map(value => value)
      )
    def totalCodeSize: Optional[Long]
    def functionCount: Optional[Long]
    def getTotalCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalCodeSize", totalCodeSize)
    def getFunctionCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("functionCount", functionCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AccountUsage
  ) extends zio.aws.lambda.model.AccountUsage.ReadOnly {
    override val totalCodeSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCodeSize())
      .map(value => value: Long)
    override val functionCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.functionCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AccountUsage
  ): zio.aws.lambda.model.AccountUsage.ReadOnly = new Wrapper(impl)
}
