package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionUrlQualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFunctionUrlConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[FunctionUrlQualifier] = Optional.Absent,
    authType: Optional[zio.aws.lambda.model.FunctionUrlAuthType] =
      Optional.Absent,
    cors: Optional[zio.aws.lambda.model.Cors] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest = {
    import UpdateFunctionUrlConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value =>
          FunctionUrlQualifier.unwrap(value): java.lang.String
        )
      )(_.qualifier)
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(cors.map(value => value.buildAwsValue()))(_.cors)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UpdateFunctionUrlConfigRequest.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionUrlConfigRequest.wrap(buildAwsValue())
}
object UpdateFunctionUrlConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionUrlConfigRequest =
      zio.aws.lambda.model.UpdateFunctionUrlConfigRequest(
        functionName,
        qualifier.map(value => value),
        authType.map(value => value),
        cors.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def qualifier: Optional[FunctionUrlQualifier]
    def authType: Optional[zio.aws.lambda.model.FunctionUrlAuthType]
    def cors: Optional[zio.aws.lambda.model.Cors.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, FunctionUrlQualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getAuthType
        : ZIO[Any, AwsError, zio.aws.lambda.model.FunctionUrlAuthType] =
      AwsError.unwrapOptionField("authType", authType)
    def getCors: ZIO[Any, AwsError, zio.aws.lambda.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("cors", cors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest
  ) extends zio.aws.lambda.model.UpdateFunctionUrlConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[FunctionUrlQualifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualifier())
        .map(value =>
          zio.aws.lambda.model.primitives.FunctionUrlQualifier(value)
        )
    override val authType: Optional[zio.aws.lambda.model.FunctionUrlAuthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value => zio.aws.lambda.model.FunctionUrlAuthType.wrap(value))
    override val cors: Optional[zio.aws.lambda.model.Cors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cors())
        .map(value => zio.aws.lambda.model.Cors.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest
  ): zio.aws.lambda.model.UpdateFunctionUrlConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
