package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  Timeout,
  RoleArn,
  KMSKeyArn,
  MemorySize,
  LayerVersionArn,
  Description,
  FunctionName,
  Handler
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFunctionConfigurationRequest(
    functionName: FunctionName,
    role: Optional[RoleArn] = Optional.Absent,
    handler: Optional[Handler] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    timeout: Optional[Timeout] = Optional.Absent,
    memorySize: Optional[MemorySize] = Optional.Absent,
    vpcConfig: Optional[zio.aws.lambda.model.VpcConfig] = Optional.Absent,
    environment: Optional[zio.aws.lambda.model.Environment] = Optional.Absent,
    runtime: Optional[zio.aws.lambda.model.Runtime] = Optional.Absent,
    deadLetterConfig: Optional[zio.aws.lambda.model.DeadLetterConfig] =
      Optional.Absent,
    kmsKeyArn: Optional[KMSKeyArn] = Optional.Absent,
    tracingConfig: Optional[zio.aws.lambda.model.TracingConfig] =
      Optional.Absent,
    revisionId: Optional[String] = Optional.Absent,
    layers: Optional[Iterable[LayerVersionArn]] = Optional.Absent,
    fileSystemConfigs: Optional[
      Iterable[zio.aws.lambda.model.FileSystemConfig]
    ] = Optional.Absent,
    imageConfig: Optional[zio.aws.lambda.model.ImageConfig] = Optional.Absent,
    ephemeralStorage: Optional[zio.aws.lambda.model.EphemeralStorage] =
      Optional.Absent,
    snapStart: Optional[zio.aws.lambda.model.SnapStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest = {
    import UpdateFunctionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        role.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        handler.map(value => Handler.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            LayerVersionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemConfigs)
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .optionallyWith(snapStart.map(value => value.buildAwsValue()))(
        _.snapStart
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateFunctionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionConfigurationRequest =
      zio.aws.lambda.model.UpdateFunctionConfigurationRequest(
        functionName,
        role.map(value => value),
        handler.map(value => value),
        description.map(value => value),
        timeout.map(value => value),
        memorySize.map(value => value),
        vpcConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        runtime.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        kmsKeyArn.map(value => value),
        tracingConfig.map(value => value.asEditable),
        revisionId.map(value => value),
        layers.map(value => value),
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageConfig.map(value => value.asEditable),
        ephemeralStorage.map(value => value.asEditable),
        snapStart.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def role: Optional[RoleArn]
    def handler: Optional[Handler]
    def description: Optional[Description]
    def timeout: Optional[Timeout]
    def memorySize: Optional[MemorySize]
    def vpcConfig: Optional[zio.aws.lambda.model.VpcConfig.ReadOnly]
    def environment: Optional[zio.aws.lambda.model.Environment.ReadOnly]
    def runtime: Optional[zio.aws.lambda.model.Runtime]
    def deadLetterConfig
        : Optional[zio.aws.lambda.model.DeadLetterConfig.ReadOnly]
    def kmsKeyArn: Optional[KMSKeyArn]
    def tracingConfig: Optional[zio.aws.lambda.model.TracingConfig.ReadOnly]
    def revisionId: Optional[String]
    def layers: Optional[List[LayerVersionArn]]
    def fileSystemConfigs
        : Optional[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]]
    def imageConfig: Optional[zio.aws.lambda.model.ImageConfig.ReadOnly]
    def ephemeralStorage
        : Optional[zio.aws.lambda.model.EphemeralStorage.ReadOnly]
    def snapStart: Optional[zio.aws.lambda.model.SnapStart.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("role", role)
    def getHandler: ZIO[Any, AwsError, Handler] =
      AwsError.unwrapOptionField("handler", handler)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.lambda.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
    def getRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getDeadLetterConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTracingConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.TracingConfig.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getLayers: ZIO[Any, AwsError, List[LayerVersionArn]] =
      AwsError.unwrapOptionField("layers", layers)
    def getFileSystemConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FileSystemConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemConfigs", fileSystemConfigs)
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.lambda.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getSnapStart
        : ZIO[Any, AwsError, zio.aws.lambda.model.SnapStart.ReadOnly] =
      AwsError.unwrapOptionField("snapStart", snapStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ) extends zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val role: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.lambda.model.primitives.RoleArn(value))
    override val handler: Optional[Handler] = zio.aws.core.internal
      .optionalFromNullable(impl.handler())
      .map(value => zio.aws.lambda.model.primitives.Handler(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.lambda.model.primitives.Timeout(value))
    override val memorySize: Optional[MemorySize] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySize())
      .map(value => zio.aws.lambda.model.primitives.MemorySize(value))
    override val vpcConfig: Optional[zio.aws.lambda.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.lambda.model.VpcConfig.wrap(value))
    override val environment
        : Optional[zio.aws.lambda.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.lambda.model.Environment.wrap(value))
    override val runtime: Optional[zio.aws.lambda.model.Runtime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val deadLetterConfig
        : Optional[zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.lambda.model.DeadLetterConfig.wrap(value))
    override val kmsKeyArn: Optional[KMSKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lambda.model.primitives.KMSKeyArn(value))
    override val tracingConfig
        : Optional[zio.aws.lambda.model.TracingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfig())
        .map(value => zio.aws.lambda.model.TracingConfig.wrap(value))
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
    override val layers: Optional[List[LayerVersionArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.LayerVersionArn(item)
        }.toList
      )
    override val fileSystemConfigs
        : Optional[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FileSystemConfig.wrap(item)
          }.toList
        )
    override val imageConfig
        : Optional[zio.aws.lambda.model.ImageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageConfig())
        .map(value => zio.aws.lambda.model.ImageConfig.wrap(value))
    override val ephemeralStorage
        : Optional[zio.aws.lambda.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.lambda.model.EphemeralStorage.wrap(value))
    override val snapStart: Optional[zio.aws.lambda.model.SnapStart.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapStart())
        .map(value => zio.aws.lambda.model.SnapStart.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest
  ): zio.aws.lambda.model.UpdateFunctionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
