package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait FunctionUrlAuthType {
  def unwrap: software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType
}
object FunctionUrlAuthType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType
  ): zio.aws.lambda.model.FunctionUrlAuthType = value match {
    case software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.AWS_IAM =>
      val r = AWS_IAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.FunctionUrlAuthType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType =
      software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.lambda.model.FunctionUrlAuthType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType =
      software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.NONE
  }
  case object AWS_IAM extends zio.aws.lambda.model.FunctionUrlAuthType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType =
      software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType.AWS_IAM
  }
}
