package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait FunctionResponseType {
  def unwrap: software.amazon.awssdk.services.lambda.model.FunctionResponseType
}
object FunctionResponseType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.FunctionResponseType
  ): zio.aws.lambda.model.FunctionResponseType = value match {
    case software.amazon.awssdk.services.lambda.model.FunctionResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.FunctionResponseType.REPORT_BATCH_ITEM_FAILURES =>
      val r = ReportBatchItemFailures
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.FunctionResponseType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionResponseType =
      software.amazon.awssdk.services.lambda.model.FunctionResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object ReportBatchItemFailures
      extends zio.aws.lambda.model.FunctionResponseType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionResponseType =
      software.amazon.awssdk.services.lambda.model.FunctionResponseType.REPORT_BATCH_ITEM_FAILURES
  }
}
