package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.RuntimeVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuntimeVersionConfig(
    runtimeVersionArn: Optional[RuntimeVersionArn] = Optional.Absent,
    error: Optional[zio.aws.lambda.model.RuntimeVersionError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig = {
    import RuntimeVersionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig
      .builder()
      .optionallyWith(
        runtimeVersionArn.map(value =>
          RuntimeVersionArn.unwrap(value): java.lang.String
        )
      )(_.runtimeVersionArn)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly =
    zio.aws.lambda.model.RuntimeVersionConfig.wrap(buildAwsValue())
}
object RuntimeVersionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.RuntimeVersionConfig =
      zio.aws.lambda.model.RuntimeVersionConfig(
        runtimeVersionArn.map(value => value),
        error.map(value => value.asEditable)
      )
    def runtimeVersionArn: Optional[RuntimeVersionArn]
    def error: Optional[zio.aws.lambda.model.RuntimeVersionError.ReadOnly]
    def getRuntimeVersionArn: ZIO[Any, AwsError, RuntimeVersionArn] =
      AwsError.unwrapOptionField("runtimeVersionArn", runtimeVersionArn)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.RuntimeVersionError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig
  ) extends zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly {
    override val runtimeVersionArn: Optional[RuntimeVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersionArn())
        .map(value => zio.aws.lambda.model.primitives.RuntimeVersionArn(value))
    override val error
        : Optional[zio.aws.lambda.model.RuntimeVersionError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.lambda.model.RuntimeVersionError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.RuntimeVersionConfig
  ): zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly = new Wrapper(impl)
}
