package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{RuntimeVersionArn, FunctionArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutRuntimeManagementConfigResponse(
    updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn,
    functionArn: FunctionArn,
    runtimeVersionArn: Optional[RuntimeVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse = {
    import PutRuntimeManagementConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse
      .builder()
      .updateRuntimeOn(updateRuntimeOn.unwrap)
      .functionArn(FunctionArn.unwrap(functionArn): java.lang.String)
      .optionallyWith(
        runtimeVersionArn.map(value =>
          RuntimeVersionArn.unwrap(value): java.lang.String
        )
      )(_.runtimeVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutRuntimeManagementConfigResponse.ReadOnly =
    zio.aws.lambda.model.PutRuntimeManagementConfigResponse
      .wrap(buildAwsValue())
}
object PutRuntimeManagementConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutRuntimeManagementConfigResponse =
      zio.aws.lambda.model.PutRuntimeManagementConfigResponse(
        updateRuntimeOn,
        functionArn,
        runtimeVersionArn.map(value => value)
      )
    def updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn
    def functionArn: FunctionArn
    def runtimeVersionArn: Optional[RuntimeVersionArn]
    def getUpdateRuntimeOn
        : ZIO[Any, Nothing, zio.aws.lambda.model.UpdateRuntimeOn] =
      ZIO.succeed(updateRuntimeOn)
    def getFunctionArn: ZIO[Any, Nothing, FunctionArn] =
      ZIO.succeed(functionArn)
    def getRuntimeVersionArn: ZIO[Any, AwsError, RuntimeVersionArn] =
      AwsError.unwrapOptionField("runtimeVersionArn", runtimeVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse
  ) extends zio.aws.lambda.model.PutRuntimeManagementConfigResponse.ReadOnly {
    override val updateRuntimeOn: zio.aws.lambda.model.UpdateRuntimeOn =
      zio.aws.lambda.model.UpdateRuntimeOn.wrap(impl.updateRuntimeOn())
    override val functionArn: FunctionArn =
      zio.aws.lambda.model.primitives.FunctionArn(impl.functionArn())
    override val runtimeVersionArn: Optional[RuntimeVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersionArn())
        .map(value => zio.aws.lambda.model.primitives.RuntimeVersionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse
  ): zio.aws.lambda.model.PutRuntimeManagementConfigResponse.ReadOnly =
    new Wrapper(impl)
}
