package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.RuntimeVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRuntimeManagementConfigResponse(
    updateRuntimeOn: Optional[zio.aws.lambda.model.UpdateRuntimeOn] =
      Optional.Absent,
    runtimeVersionArn: Optional[RuntimeVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse = {
    import GetRuntimeManagementConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse
      .builder()
      .optionallyWith(updateRuntimeOn.map(value => value.unwrap))(
        _.updateRuntimeOn
      )
      .optionallyWith(
        runtimeVersionArn.map(value =>
          RuntimeVersionArn.unwrap(value): java.lang.String
        )
      )(_.runtimeVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetRuntimeManagementConfigResponse.ReadOnly =
    zio.aws.lambda.model.GetRuntimeManagementConfigResponse
      .wrap(buildAwsValue())
}
object GetRuntimeManagementConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetRuntimeManagementConfigResponse =
      zio.aws.lambda.model.GetRuntimeManagementConfigResponse(
        updateRuntimeOn.map(value => value),
        runtimeVersionArn.map(value => value)
      )
    def updateRuntimeOn: Optional[zio.aws.lambda.model.UpdateRuntimeOn]
    def runtimeVersionArn: Optional[RuntimeVersionArn]
    def getUpdateRuntimeOn
        : ZIO[Any, AwsError, zio.aws.lambda.model.UpdateRuntimeOn] =
      AwsError.unwrapOptionField("updateRuntimeOn", updateRuntimeOn)
    def getRuntimeVersionArn: ZIO[Any, AwsError, RuntimeVersionArn] =
      AwsError.unwrapOptionField("runtimeVersionArn", runtimeVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse
  ) extends zio.aws.lambda.model.GetRuntimeManagementConfigResponse.ReadOnly {
    override val updateRuntimeOn
        : Optional[zio.aws.lambda.model.UpdateRuntimeOn] = zio.aws.core.internal
      .optionalFromNullable(impl.updateRuntimeOn())
      .map(value => zio.aws.lambda.model.UpdateRuntimeOn.wrap(value))
    override val runtimeVersionArn: Optional[RuntimeVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersionArn())
        .map(value => zio.aws.lambda.model.primitives.RuntimeVersionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse
  ): zio.aws.lambda.model.GetRuntimeManagementConfigResponse.ReadOnly =
    new Wrapper(impl)
}
