package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  EnvironmentVariableValue,
  EnvironmentVariableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnvironmentResponse(
    variables: Optional[
      Map[EnvironmentVariableName, EnvironmentVariableValue]
    ] = Optional.Absent,
    error: Optional[zio.aws.lambda.model.EnvironmentError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.EnvironmentResponse = {
    import EnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.EnvironmentResponse
      .builder()
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableName
                .unwrap(key): java.lang.String) -> (EnvironmentVariableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.EnvironmentResponse.ReadOnly =
    zio.aws.lambda.model.EnvironmentResponse.wrap(buildAwsValue())
}
object EnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.EnvironmentResponse =
      zio.aws.lambda.model.EnvironmentResponse(
        variables.map(value => value),
        error.map(value => value.asEditable)
      )
    def variables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]]
    def error: Optional[zio.aws.lambda.model.EnvironmentError.ReadOnly]
    def getVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableName,
      EnvironmentVariableValue
    ]] = AwsError.unwrapOptionField("variables", variables)
    def getError
        : ZIO[Any, AwsError, zio.aws.lambda.model.EnvironmentError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ) extends zio.aws.lambda.model.EnvironmentResponse.ReadOnly {
    override val variables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lambda.model.primitives
                .EnvironmentVariableName(key) -> zio.aws.lambda.model.primitives
                .EnvironmentVariableValue(value)
            })
            .toMap
        )
    override val error
        : Optional[zio.aws.lambda.model.EnvironmentError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.lambda.model.EnvironmentError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentResponse
  ): zio.aws.lambda.model.EnvironmentResponse.ReadOnly = new Wrapper(impl)
}
