package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait SnapStartOptimizationStatus {
  def unwrap
      : software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus
}
object SnapStartOptimizationStatus {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus
  ): zio.aws.lambda.model.SnapStartOptimizationStatus = value match {
    case software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.ON =>
      val r = On
      r
    case software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.OFF =>
      val r = Off
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.SnapStartOptimizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus =
      software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object On extends zio.aws.lambda.model.SnapStartOptimizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus =
      software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.ON
  }
  case object Off extends zio.aws.lambda.model.SnapStartOptimizationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus =
      software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus.OFF
  }
}
