package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  S3ObjectVersion,
  Blob,
  FunctionName,
  S3Bucket,
  S3Key
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFunctionCodeRequest(
    functionName: FunctionName,
    zipFile: Optional[Blob] = Optional.Absent,
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    s3ObjectVersion: Optional[S3ObjectVersion] = Optional.Absent,
    imageUri: Optional[String] = Optional.Absent,
    publish: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    revisionId: Optional[String] = Optional.Absent,
    architectures: Optional[Iterable[zio.aws.lambda.model.Architecture]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest = {
    import UpdateFunctionCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        zipFile.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.zipFile)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        s3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.s3ObjectVersion)
      .optionallyWith(imageUri.map(value => value: java.lang.String))(
        _.imageUri
      )
      .optionallyWith(publish.map(value => value: java.lang.Boolean))(_.publish)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UpdateFunctionCodeRequest.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionCodeRequest.wrap(buildAwsValue())
}
object UpdateFunctionCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionCodeRequest =
      zio.aws.lambda.model.UpdateFunctionCodeRequest(
        functionName,
        zipFile.map(value => value),
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3ObjectVersion.map(value => value),
        imageUri.map(value => value),
        publish.map(value => value),
        dryRun.map(value => value),
        revisionId.map(value => value),
        architectures.map(value => value)
      )
    def functionName: FunctionName
    def zipFile: Optional[Blob]
    def s3Bucket: Optional[S3Bucket]
    def s3Key: Optional[S3Key]
    def s3ObjectVersion: Optional[S3ObjectVersion]
    def imageUri: Optional[String]
    def publish: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def revisionId: Optional[String]
    def architectures: Optional[List[zio.aws.lambda.model.Architecture]]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getZipFile: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("zipFile", zipFile)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("s3ObjectVersion", s3ObjectVersion)
    def getImageUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageUri", imageUri)
    def getPublish: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publish", publish)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] =
      AwsError.unwrapOptionField("architectures", architectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest
  ) extends zio.aws.lambda.model.UpdateFunctionCodeRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val zipFile: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.zipFile())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.lambda.model.primitives.S3Bucket(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.lambda.model.primitives.S3Key(value))
    override val s3ObjectVersion: Optional[S3ObjectVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ObjectVersion())
        .map(value => zio.aws.lambda.model.primitives.S3ObjectVersion(value))
    override val imageUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUri())
      .map(value => value: String)
    override val publish: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publish())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
    override val architectures
        : Optional[List[zio.aws.lambda.model.Architecture]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Architecture.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest
  ): zio.aws.lambda.model.UpdateFunctionCodeRequest.ReadOnly = new Wrapper(impl)
}
