package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait EndPointType {
  def unwrap: software.amazon.awssdk.services.lambda.model.EndPointType
}
object EndPointType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.EndPointType
  ): zio.aws.lambda.model.EndPointType = value match {
    case software.amazon.awssdk.services.lambda.model.EndPointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.EndPointType.KAFKA_BOOTSTRAP_SERVERS =>
      val r = KAFKA_BOOTSTRAP_SERVERS
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.EndPointType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EndPointType =
      software.amazon.awssdk.services.lambda.model.EndPointType.UNKNOWN_TO_SDK_VERSION
  }
  case object KAFKA_BOOTSTRAP_SERVERS
      extends zio.aws.lambda.model.EndPointType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EndPointType =
      software.amazon.awssdk.services.lambda.model.EndPointType.KAFKA_BOOTSTRAP_SERVERS
  }
}
