package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Description,
  Version,
  Alias,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAliasRequest(
    functionName: FunctionName,
    name: Alias,
    functionVersion: Version,
    description: Optional[Description] = Optional.Absent,
    routingConfig: Optional[zio.aws.lambda.model.AliasRoutingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateAliasRequest = {
    import CreateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateAliasRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .name(Alias.unwrap(name): java.lang.String)
      .functionVersion(Version.unwrap(functionVersion): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateAliasRequest.ReadOnly =
    zio.aws.lambda.model.CreateAliasRequest.wrap(buildAwsValue())
}
object CreateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateAliasRequest =
      zio.aws.lambda.model.CreateAliasRequest(
        functionName,
        name,
        functionVersion,
        description.map(value => value),
        routingConfig.map(value => value.asEditable)
      )
    def functionName: FunctionName
    def name: Alias
    def functionVersion: Version
    def description: Optional[Description]
    def routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getName: ZIO[Any, Nothing, Alias] = ZIO.succeed(name)
    def getFunctionVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(functionVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("routingConfig", routingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasRequest
  ) extends zio.aws.lambda.model.CreateAliasRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val name: Alias =
      zio.aws.lambda.model.primitives.Alias(impl.name())
    override val functionVersion: Version =
      zio.aws.lambda.model.primitives.Version(impl.functionVersion())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value =>
          zio.aws.lambda.model.AliasRoutingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasRequest
  ): zio.aws.lambda.model.CreateAliasRequest.ReadOnly = new Wrapper(impl)
}
