package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFunctionResponse(
    configuration: Optional[zio.aws.lambda.model.FunctionConfiguration] =
      Optional.Absent,
    code: Optional[zio.aws.lambda.model.FunctionCodeLocation] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    concurrency: Optional[zio.aws.lambda.model.Concurrency] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionResponse = {
    import GetFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(concurrency.map(value => value.buildAwsValue()))(
        _.concurrency
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetFunctionResponse.ReadOnly =
    zio.aws.lambda.model.GetFunctionResponse.wrap(buildAwsValue())
}
object GetFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionResponse =
      zio.aws.lambda.model.GetFunctionResponse(
        configuration.map(value => value.asEditable),
        code.map(value => value.asEditable),
        tags.map(value => value),
        concurrency.map(value => value.asEditable)
      )
    def configuration
        : Optional[zio.aws.lambda.model.FunctionConfiguration.ReadOnly]
    def code: Optional[zio.aws.lambda.model.FunctionCodeLocation.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def concurrency: Optional[zio.aws.lambda.model.Concurrency.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.FunctionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.FunctionCodeLocation.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConcurrency
        : ZIO[Any, AwsError, zio.aws.lambda.model.Concurrency.ReadOnly] =
      AwsError.unwrapOptionField("concurrency", concurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionResponse
  ) extends zio.aws.lambda.model.GetFunctionResponse.ReadOnly {
    override val configuration
        : Optional[zio.aws.lambda.model.FunctionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.lambda.model.FunctionConfiguration.wrap(value))
    override val code
        : Optional[zio.aws.lambda.model.FunctionCodeLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.lambda.model.FunctionCodeLocation.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives
              .TagKey(key) -> zio.aws.lambda.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val concurrency
        : Optional[zio.aws.lambda.model.Concurrency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.concurrency())
        .map(value => zio.aws.lambda.model.Concurrency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionResponse
  ): zio.aws.lambda.model.GetFunctionResponse.ReadOnly = new Wrapper(impl)
}
