package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{MaxListItems, NamespacedFunctionName}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVersionsByFunctionRequest(
    functionName: NamespacedFunctionName,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[MaxListItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest = {
    import ListVersionsByFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListVersionsByFunctionRequest.ReadOnly =
    zio.aws.lambda.model.ListVersionsByFunctionRequest.wrap(buildAwsValue())
}
object ListVersionsByFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListVersionsByFunctionRequest =
      zio.aws.lambda.model.ListVersionsByFunctionRequest(
        functionName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def functionName: NamespacedFunctionName
    def marker: Optional[String]
    def maxItems: Optional[MaxListItems]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest
  ) extends zio.aws.lambda.model.ListVersionsByFunctionRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[MaxListItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest
  ): zio.aws.lambda.model.ListVersionsByFunctionRequest.ReadOnly = new Wrapper(
    impl
  )
}
