package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{LayerArn, LayerName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LayersListItem(
    layerName: Optional[LayerName] = Optional.Absent,
    layerArn: Optional[LayerArn] = Optional.Absent,
    latestMatchingVersion: Optional[
      zio.aws.lambda.model.LayerVersionsListItem
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LayersListItem = {
    import LayersListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LayersListItem
      .builder()
      .optionallyWith(
        layerName.map(value => LayerName.unwrap(value): java.lang.String)
      )(_.layerName)
      .optionallyWith(
        layerArn.map(value => LayerArn.unwrap(value): java.lang.String)
      )(_.layerArn)
      .optionallyWith(
        latestMatchingVersion.map(value => value.buildAwsValue())
      )(_.latestMatchingVersion)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LayersListItem.ReadOnly =
    zio.aws.lambda.model.LayersListItem.wrap(buildAwsValue())
}
object LayersListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LayersListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LayersListItem =
      zio.aws.lambda.model.LayersListItem(
        layerName.map(value => value),
        layerArn.map(value => value),
        latestMatchingVersion.map(value => value.asEditable)
      )
    def layerName: Optional[LayerName]
    def layerArn: Optional[LayerArn]
    def latestMatchingVersion
        : Optional[zio.aws.lambda.model.LayerVersionsListItem.ReadOnly]
    def getLayerName: ZIO[Any, AwsError, LayerName] =
      AwsError.unwrapOptionField("layerName", layerName)
    def getLayerArn: ZIO[Any, AwsError, LayerArn] =
      AwsError.unwrapOptionField("layerArn", layerArn)
    def getLatestMatchingVersion: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
    ] =
      AwsError.unwrapOptionField("latestMatchingVersion", latestMatchingVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LayersListItem
  ) extends zio.aws.lambda.model.LayersListItem.ReadOnly {
    override val layerName: Optional[LayerName] = zio.aws.core.internal
      .optionalFromNullable(impl.layerName())
      .map(value => zio.aws.lambda.model.primitives.LayerName(value))
    override val layerArn: Optional[LayerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.layerArn())
      .map(value => zio.aws.lambda.model.primitives.LayerArn(value))
    override val latestMatchingVersion
        : Optional[zio.aws.lambda.model.LayerVersionsListItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestMatchingVersion())
        .map(value => zio.aws.lambda.model.LayerVersionsListItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LayersListItem
  ): zio.aws.lambda.model.LayersListItem.ReadOnly = new Wrapper(impl)
}
