package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FunctionCodeLocation(
    repositoryType: Optional[String] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    imageUri: Optional[String] = Optional.Absent,
    resolvedImageUri: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FunctionCodeLocation = {
    import FunctionCodeLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FunctionCodeLocation
      .builder()
      .optionallyWith(repositoryType.map(value => value: java.lang.String))(
        _.repositoryType
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(imageUri.map(value => value: java.lang.String))(
        _.imageUri
      )
      .optionallyWith(resolvedImageUri.map(value => value: java.lang.String))(
        _.resolvedImageUri
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FunctionCodeLocation.ReadOnly =
    zio.aws.lambda.model.FunctionCodeLocation.wrap(buildAwsValue())
}
object FunctionCodeLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FunctionCodeLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FunctionCodeLocation =
      zio.aws.lambda.model.FunctionCodeLocation(
        repositoryType.map(value => value),
        location.map(value => value),
        imageUri.map(value => value),
        resolvedImageUri.map(value => value)
      )
    def repositoryType: Optional[String]
    def location: Optional[String]
    def imageUri: Optional[String]
    def resolvedImageUri: Optional[String]
    def getRepositoryType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("repositoryType", repositoryType)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getImageUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageUri", imageUri)
    def getResolvedImageUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolvedImageUri", resolvedImageUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FunctionCodeLocation
  ) extends zio.aws.lambda.model.FunctionCodeLocation.ReadOnly {
    override val repositoryType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryType())
      .map(value => value: String)
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val imageUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUri())
      .map(value => value: String)
    override val resolvedImageUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedImageUri())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FunctionCodeLocation
  ): zio.aws.lambda.model.FunctionCodeLocation.ReadOnly = new Wrapper(impl)
}
