package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.ReservedConcurrentExecutions
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFunctionConcurrencyResponse(
    reservedConcurrentExecutions: Optional[ReservedConcurrentExecutions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse = {
    import GetFunctionConcurrencyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
      .builder()
      .optionallyWith(
        reservedConcurrentExecutions.map(value =>
          ReservedConcurrentExecutions.unwrap(value): Integer
        )
      )(_.reservedConcurrentExecutions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly =
    zio.aws.lambda.model.GetFunctionConcurrencyResponse.wrap(buildAwsValue())
}
object GetFunctionConcurrencyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionConcurrencyResponse =
      zio.aws.lambda.model.GetFunctionConcurrencyResponse(
        reservedConcurrentExecutions.map(value => value)
      )
    def reservedConcurrentExecutions: Optional[ReservedConcurrentExecutions]
    def getReservedConcurrentExecutions
        : ZIO[Any, AwsError, ReservedConcurrentExecutions] =
      AwsError.unwrapOptionField(
        "reservedConcurrentExecutions",
        reservedConcurrentExecutions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ) extends zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly {
    override val reservedConcurrentExecutions
        : Optional[ReservedConcurrentExecutions] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedConcurrentExecutions())
      .map(value =>
        zio.aws.lambda.model.primitives.ReservedConcurrentExecutions(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse
  ): zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly = new Wrapper(
    impl
  )
}
