package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{LayerVersionNumber, LayerName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLayerVersionRequest(
    layerName: LayerName,
    versionNumber: LayerVersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest = {
    import GetLayerVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest
      .builder()
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .versionNumber(LayerVersionNumber.unwrap(versionNumber): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetLayerVersionRequest.ReadOnly =
    zio.aws.lambda.model.GetLayerVersionRequest.wrap(buildAwsValue())
}
object GetLayerVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetLayerVersionRequest =
      zio.aws.lambda.model.GetLayerVersionRequest(layerName, versionNumber)
    def layerName: LayerName
    def versionNumber: LayerVersionNumber
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getVersionNumber: ZIO[Any, Nothing, LayerVersionNumber] =
      ZIO.succeed(versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest
  ) extends zio.aws.lambda.model.GetLayerVersionRequest.ReadOnly {
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val versionNumber: LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber(impl.versionNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest
  ): zio.aws.lambda.model.GetLayerVersionRequest.ReadOnly = new Wrapper(impl)
}
