package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, NamespacedFunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFunctionRequest(
    functionName: NamespacedFunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionRequest = {
    import GetFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetFunctionRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionRequest.wrap(buildAwsValue())
}
object GetFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionRequest =
      zio.aws.lambda.model
        .GetFunctionRequest(functionName, qualifier.map(value => value))
    def functionName: NamespacedFunctionName
    def qualifier: Optional[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRequest
  ) extends zio.aws.lambda.model.GetFunctionRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRequest
  ): zio.aws.lambda.model.GetFunctionRequest.ReadOnly = new Wrapper(impl)
}
