package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.Pattern
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(pattern: Optional[Pattern] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.lambda.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.Filter
      .builder()
      .optionallyWith(
        pattern.map(value => Pattern.unwrap(value): java.lang.String)
      )(_.pattern)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.Filter.ReadOnly =
    zio.aws.lambda.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.Filter =
      zio.aws.lambda.model.Filter(pattern.map(value => value))
    def pattern: Optional[Pattern]
    def getPattern: ZIO[Any, AwsError, Pattern] =
      AwsError.unwrapOptionField("pattern", pattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.Filter
  ) extends zio.aws.lambda.model.Filter.ReadOnly {
    override val pattern: Optional[Pattern] = zio.aws.core.internal
      .optionalFromNullable(impl.pattern())
      .map(value => zio.aws.lambda.model.primitives.Pattern(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.Filter
  ): zio.aws.lambda.model.Filter.ReadOnly = new Wrapper(impl)
}
