package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFunctionUrlConfigsResponse(
    functionUrlConfigs: Iterable[zio.aws.lambda.model.FunctionUrlConfig],
    nextMarker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse = {
    import ListFunctionUrlConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse
      .builder()
      .functionUrlConfigs(functionUrlConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListFunctionUrlConfigsResponse.ReadOnly =
    zio.aws.lambda.model.ListFunctionUrlConfigsResponse.wrap(buildAwsValue())
}
object ListFunctionUrlConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListFunctionUrlConfigsResponse =
      zio.aws.lambda.model.ListFunctionUrlConfigsResponse(
        functionUrlConfigs.map { item =>
          item.asEditable
        },
        nextMarker.map(value => value)
      )
    def functionUrlConfigs
        : List[zio.aws.lambda.model.FunctionUrlConfig.ReadOnly]
    def nextMarker: Optional[String]
    def getFunctionUrlConfigs: ZIO[Any, Nothing, List[
      zio.aws.lambda.model.FunctionUrlConfig.ReadOnly
    ]] = ZIO.succeed(functionUrlConfigs)
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse
  ) extends zio.aws.lambda.model.ListFunctionUrlConfigsResponse.ReadOnly {
    override val functionUrlConfigs
        : List[zio.aws.lambda.model.FunctionUrlConfig.ReadOnly] = impl
      .functionUrlConfigs()
      .asScala
      .map { item =>
        zio.aws.lambda.model.FunctionUrlConfig.wrap(item)
      }
      .toList
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse
  ): zio.aws.lambda.model.ListFunctionUrlConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
