package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait Runtime {
  def unwrap: software.amazon.awssdk.services.lambda.model.Runtime
}
object Runtime {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.Runtime
  ): zio.aws.lambda.model.Runtime = value match {
    case software.amazon.awssdk.services.lambda.model.Runtime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS =>
      val r = nodejs
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS4_3 =>
      val r = `nodejs4.3`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS6_10 =>
      val r = `nodejs6.10`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS8_10 =>
      val r = `nodejs8.10`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS10_X =>
      val r = `nodejs10.x`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS12_X =>
      val r = `nodejs12.x`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS14_X =>
      val r = `nodejs14.x`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.JAVA8 =>
      val r = java8
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.JAVA8_AL2 =>
      val r = `java8.al2`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.JAVA11 =>
      val r = java11
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PYTHON2_7 =>
      val r = `python2.7`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_6 =>
      val r = `python3.6`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_7 =>
      val r = `python3.7`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_8 =>
      val r = `python3.8`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_9 =>
      val r = `python3.9`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE1_0 =>
      val r = `dotnetcore1.0`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE2_0 =>
      val r = `dotnetcore2.0`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE2_1 =>
      val r = `dotnetcore2.1`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE3_1 =>
      val r = `dotnetcore3.1`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.DOTNET6 =>
      val r = dotnet6
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.NODEJS4_3_EDGE =>
      val r = `nodejs4.3-edge`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.GO1_X =>
      val r = `go1.x`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.RUBY2_5 =>
      val r = `ruby2.5`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.RUBY2_7 =>
      val r = `ruby2.7`
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PROVIDED =>
      val r = provided
      r
    case software.amazon.awssdk.services.lambda.model.Runtime.PROVIDED_AL2 =>
      val r = `provided.al2`
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.UNKNOWN_TO_SDK_VERSION
  }
  case object nodejs extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS
  }
  case object `nodejs4.3` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS4_3
  }
  case object `nodejs6.10` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS6_10
  }
  case object `nodejs8.10` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS8_10
  }
  case object `nodejs10.x` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS10_X
  }
  case object `nodejs12.x` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS12_X
  }
  case object `nodejs14.x` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS14_X
  }
  case object java8 extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.JAVA8
  }
  case object `java8.al2` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.JAVA8_AL2
  }
  case object java11 extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.JAVA11
  }
  case object `python2.7` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PYTHON2_7
  }
  case object `python3.6` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_6
  }
  case object `python3.7` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_7
  }
  case object `python3.8` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_8
  }
  case object `python3.9` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PYTHON3_9
  }
  case object `dotnetcore1.0` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE1_0
  }
  case object `dotnetcore2.0` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE2_0
  }
  case object `dotnetcore2.1` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE2_1
  }
  case object `dotnetcore3.1` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.DOTNETCORE3_1
  }
  case object dotnet6 extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.DOTNET6
  }
  case object `nodejs4.3-edge` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.NODEJS4_3_EDGE
  }
  case object `go1.x` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.GO1_X
  }
  case object `ruby2.5` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.RUBY2_5
  }
  case object `ruby2.7` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.RUBY2_7
  }
  case object provided extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PROVIDED
  }
  case object `provided.al2` extends zio.aws.lambda.model.Runtime {
    override def unwrap: software.amazon.awssdk.services.lambda.model.Runtime =
      software.amazon.awssdk.services.lambda.model.Runtime.PROVIDED_AL2
  }
}
