package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProvisionedConcurrencyConfigRequest(
    functionName: FunctionName,
    qualifier: Qualifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest = {
    import DeleteProvisionedConcurrencyConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .qualifier(Qualifier.unwrap(qualifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.DeleteProvisionedConcurrencyConfigRequest.ReadOnly =
    zio.aws.lambda.model.DeleteProvisionedConcurrencyConfigRequest
      .wrap(buildAwsValue())
}
object DeleteProvisionedConcurrencyConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.DeleteProvisionedConcurrencyConfigRequest =
      zio.aws.lambda.model
        .DeleteProvisionedConcurrencyConfigRequest(functionName, qualifier)
    def functionName: FunctionName
    def qualifier: Qualifier
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, Nothing, Qualifier] = ZIO.succeed(qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
  ) extends zio.aws.lambda.model.DeleteProvisionedConcurrencyConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Qualifier =
      zio.aws.lambda.model.primitives.Qualifier(impl.qualifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest
  ): zio.aws.lambda.model.DeleteProvisionedConcurrencyConfigRequest.ReadOnly =
    new Wrapper(impl)
}
