package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  StatementId,
  LayerVersionNumber,
  LayerName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveLayerVersionPermissionRequest(
    layerName: LayerName,
    versionNumber: LayerVersionNumber,
    statementId: StatementId,
    revisionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest = {
    import RemoveLayerVersionPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest
      .builder()
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .versionNumber(LayerVersionNumber.unwrap(versionNumber): java.lang.Long)
      .statementId(StatementId.unwrap(statementId): java.lang.String)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.RemoveLayerVersionPermissionRequest.ReadOnly =
    zio.aws.lambda.model.RemoveLayerVersionPermissionRequest
      .wrap(buildAwsValue())
}
object RemoveLayerVersionPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.RemoveLayerVersionPermissionRequest =
      zio.aws.lambda.model.RemoveLayerVersionPermissionRequest(
        layerName,
        versionNumber,
        statementId,
        revisionId.map(value => value)
      )
    def layerName: LayerName
    def versionNumber: LayerVersionNumber
    def statementId: StatementId
    def revisionId: Optional[String]
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getVersionNumber: ZIO[Any, Nothing, LayerVersionNumber] =
      ZIO.succeed(versionNumber)
    def getStatementId: ZIO[Any, Nothing, StatementId] =
      ZIO.succeed(statementId)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest
  ) extends zio.aws.lambda.model.RemoveLayerVersionPermissionRequest.ReadOnly {
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val versionNumber: LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber(impl.versionNumber())
    override val statementId: StatementId =
      zio.aws.lambda.model.primitives.StatementId(impl.statementId())
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest
  ): zio.aws.lambda.model.RemoveLayerVersionPermissionRequest.ReadOnly =
    new Wrapper(impl)
}
