package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaxProvisionedConcurrencyConfigListItems,
  FunctionName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProvisionedConcurrencyConfigsRequest(
    functionName: FunctionName,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[MaxProvisionedConcurrencyConfigListItems] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest = {
    import ListProvisionedConcurrencyConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value =>
          MaxProvisionedConcurrencyConfigListItems.unwrap(value): Integer
        )
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest.ReadOnly =
    zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest
      .wrap(buildAwsValue())
}
object ListProvisionedConcurrencyConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest =
      zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest(
        functionName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def functionName: FunctionName
    def marker: Optional[String]
    def maxItems: Optional[MaxProvisionedConcurrencyConfigListItems]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems
        : ZIO[Any, AwsError, MaxProvisionedConcurrencyConfigListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
  ) extends zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[MaxProvisionedConcurrencyConfigListItems] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxItems())
        .map(value =>
          zio.aws.lambda.model.primitives
            .MaxProvisionedConcurrencyConfigListItems(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest
  ): zio.aws.lambda.model.ListProvisionedConcurrencyConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
