package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Alias, FunctionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAliasRequest(functionName: FunctionName, name: Alias) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteAliasRequest = {
    import DeleteAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteAliasRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .name(Alias.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DeleteAliasRequest.ReadOnly =
    zio.aws.lambda.model.DeleteAliasRequest.wrap(buildAwsValue())
}
object DeleteAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeleteAliasRequest =
      zio.aws.lambda.model.DeleteAliasRequest(functionName, name)
    def functionName: FunctionName
    def name: Alias
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getName: ZIO[Any, Nothing, Alias] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteAliasRequest
  ) extends zio.aws.lambda.model.DeleteAliasRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val name: Alias =
      zio.aws.lambda.model.primitives.Alias(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteAliasRequest
  ): zio.aws.lambda.model.DeleteAliasRequest.ReadOnly = new Wrapper(impl)
}
