package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Qualifier,
  NamespacedStatementId,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemovePermissionRequest(
    functionName: FunctionName,
    statementId: NamespacedStatementId,
    qualifier: Option[Qualifier] = None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.RemovePermissionRequest = {
    import RemovePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.RemovePermissionRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .statementId(NamespacedStatementId.unwrap(statementId): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.RemovePermissionRequest.ReadOnly =
    zio.aws.lambda.model.RemovePermissionRequest.wrap(buildAwsValue())
}
object RemovePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.RemovePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.RemovePermissionRequest =
      zio.aws.lambda.model.RemovePermissionRequest(
        functionName,
        statementId,
        qualifier.map(value => value),
        revisionId.map(value => value)
      )
    def functionName: FunctionName
    def statementId: NamespacedStatementId
    def qualifier: Option[Qualifier]
    def revisionId: Option[String]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getStatementId: ZIO[Any, Nothing, NamespacedStatementId] =
      ZIO.succeed(statementId)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.RemovePermissionRequest
  ) extends zio.aws.lambda.model.RemovePermissionRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val statementId: NamespacedStatementId =
      zio.aws.lambda.model.primitives.NamespacedStatementId(impl.statementId())
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.RemovePermissionRequest
  ): zio.aws.lambda.model.RemovePermissionRequest.ReadOnly = new Wrapper(impl)
}
