package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  LicenseInfo,
  LayerVersionNumber,
  Timestamp,
  LayerVersionArn,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LayerVersionsListItem(
    layerVersionArn: Option[LayerVersionArn] = None,
    version: Option[LayerVersionNumber] = None,
    description: Option[Description] = None,
    createdDate: Option[Timestamp] = None,
    compatibleRuntimes: Option[Iterable[zio.aws.lambda.model.Runtime]] = None,
    licenseInfo: Option[LicenseInfo] = None,
    compatibleArchitectures: Option[
      Iterable[zio.aws.lambda.model.Architecture]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LayerVersionsListItem = {
    import LayerVersionsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
      .builder()
      .optionallyWith(
        layerVersionArn.map(value =>
          LayerVersionArn.unwrap(value): java.lang.String
        )
      )(_.layerVersionArn)
      .optionallyWith(
        version.map(value => LayerVersionNumber.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleRuntimesWithStrings)
      .optionallyWith(
        licenseInfo.map(value => LicenseInfo.unwrap(value): java.lang.String)
      )(_.licenseInfo)
      .optionallyWith(
        compatibleArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleArchitecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LayerVersionsListItem.ReadOnly =
    zio.aws.lambda.model.LayerVersionsListItem.wrap(buildAwsValue())
}
object LayerVersionsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LayerVersionsListItem =
      zio.aws.lambda.model.LayerVersionsListItem(
        layerVersionArn.map(value => value),
        version.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        compatibleRuntimes.map(value => value),
        licenseInfo.map(value => value),
        compatibleArchitectures.map(value => value)
      )
    def layerVersionArn: Option[LayerVersionArn]
    def version: Option[LayerVersionNumber]
    def description: Option[Description]
    def createdDate: Option[Timestamp]
    def compatibleRuntimes: Option[List[zio.aws.lambda.model.Runtime]]
    def licenseInfo: Option[LicenseInfo]
    def compatibleArchitectures: Option[List[zio.aws.lambda.model.Architecture]]
    def getLayerVersionArn: ZIO[Any, AwsError, LayerVersionArn] =
      AwsError.unwrapOptionField("layerVersionArn", layerVersionArn)
    def getVersion: ZIO[Any, AwsError, LayerVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getCompatibleRuntimes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Runtime]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getLicenseInfo: ZIO[Any, AwsError, LicenseInfo] =
      AwsError.unwrapOptionField("licenseInfo", licenseInfo)
    def getCompatibleArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] = AwsError
      .unwrapOptionField("compatibleArchitectures", compatibleArchitectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ) extends zio.aws.lambda.model.LayerVersionsListItem.ReadOnly {
    override val layerVersionArn: Option[LayerVersionArn] = scala
      .Option(impl.layerVersionArn())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionArn(value))
    override val version: Option[LayerVersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionNumber(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
    override val compatibleRuntimes
        : Option[List[zio.aws.lambda.model.Runtime]] = scala
      .Option(impl.compatibleRuntimes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Runtime.wrap(item)
        }.toList
      )
    override val licenseInfo: Option[LicenseInfo] = scala
      .Option(impl.licenseInfo())
      .map(value => zio.aws.lambda.model.primitives.LicenseInfo(value))
    override val compatibleArchitectures
        : Option[List[zio.aws.lambda.model.Architecture]] = scala
      .Option(impl.compatibleArchitectures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Architecture.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ): zio.aws.lambda.model.LayerVersionsListItem.ReadOnly = new Wrapper(impl)
}
