package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  Timestamp,
  NonNegativeInteger,
  PositiveInteger,
  FunctionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionedConcurrencyConfigListItem(
    functionArn: Option[FunctionArn] = None,
    requestedProvisionedConcurrentExecutions: Option[PositiveInteger] = None,
    availableProvisionedConcurrentExecutions: Option[NonNegativeInteger] = None,
    allocatedProvisionedConcurrentExecutions: Option[NonNegativeInteger] = None,
    status: Option[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum] =
      None,
    statusReason: Option[String] = None,
    lastModified: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem = {
    import ProvisionedConcurrencyConfigListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
      .builder()
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        requestedProvisionedConcurrentExecutions.map(value =>
          PositiveInteger.unwrap(value): Integer
        )
      )(_.requestedProvisionedConcurrentExecutions)
      .optionallyWith(
        availableProvisionedConcurrentExecutions.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.availableProvisionedConcurrentExecutions)
      .optionallyWith(
        allocatedProvisionedConcurrentExecutions.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.allocatedProvisionedConcurrentExecutions)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.lastModified)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly =
    zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem
      .wrap(buildAwsValue())
}
object ProvisionedConcurrencyConfigListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem =
      zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem(
        functionArn.map(value => value),
        requestedProvisionedConcurrentExecutions.map(value => value),
        availableProvisionedConcurrentExecutions.map(value => value),
        allocatedProvisionedConcurrentExecutions.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        lastModified.map(value => value)
      )
    def functionArn: Option[FunctionArn]
    def requestedProvisionedConcurrentExecutions: Option[PositiveInteger]
    def availableProvisionedConcurrentExecutions: Option[NonNegativeInteger]
    def allocatedProvisionedConcurrentExecutions: Option[NonNegativeInteger]
    def status: Option[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum]
    def statusReason: Option[String]
    def lastModified: Option[Timestamp]
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getRequestedProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, PositiveInteger] = AwsError.unwrapOptionField(
      "requestedProvisionedConcurrentExecutions",
      requestedProvisionedConcurrentExecutions
    )
    def getAvailableProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, NonNegativeInteger] = AwsError.unwrapOptionField(
      "availableProvisionedConcurrentExecutions",
      availableProvisionedConcurrentExecutions
    )
    def getAllocatedProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, NonNegativeInteger] = AwsError.unwrapOptionField(
      "allocatedProvisionedConcurrentExecutions",
      allocatedProvisionedConcurrentExecutions
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ) extends zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly {
    override val functionArn: Option[FunctionArn] = scala
      .Option(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val requestedProvisionedConcurrentExecutions
        : Option[PositiveInteger] = scala
      .Option(impl.requestedProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.PositiveInteger(value))
    override val availableProvisionedConcurrentExecutions
        : Option[NonNegativeInteger] = scala
      .Option(impl.availableProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.NonNegativeInteger(value))
    override val allocatedProvisionedConcurrentExecutions
        : Option[NonNegativeInteger] = scala
      .Option(impl.allocatedProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.NonNegativeInteger(value))
    override val status
        : Option[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum.wrap(value)
      )
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val lastModified: Option[Timestamp] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ): zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly =
    new Wrapper(impl)
}
