package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnvironmentError(
    errorCode: Option[String] = None,
    message: Option[SensitiveString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.EnvironmentError = {
    import EnvironmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.EnvironmentError
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(
        message.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.EnvironmentError.ReadOnly =
    zio.aws.lambda.model.EnvironmentError.wrap(buildAwsValue())
}
object EnvironmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.EnvironmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.EnvironmentError =
      zio.aws.lambda.model.EnvironmentError(
        errorCode.map(value => value),
        message.map(value => value)
      )
    def errorCode: Option[String]
    def message: Option[SensitiveString]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentError
  ) extends zio.aws.lambda.model.EnvironmentError.ReadOnly {
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val message: Option[SensitiveString] = scala
      .Option(impl.message())
      .map(value => zio.aws.lambda.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.EnvironmentError
  ): zio.aws.lambda.model.EnvironmentError.ReadOnly = new Wrapper(impl)
}
