package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  LayerArn,
  LicenseInfo,
  LayerVersionNumber,
  Timestamp,
  LayerVersionArn,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublishLayerVersionResponse(
    content: Option[zio.aws.lambda.model.LayerVersionContentOutput] = None,
    layerArn: Option[LayerArn] = None,
    layerVersionArn: Option[LayerVersionArn] = None,
    description: Option[Description] = None,
    createdDate: Option[Timestamp] = None,
    version: Option[LayerVersionNumber] = None,
    compatibleRuntimes: Option[Iterable[zio.aws.lambda.model.Runtime]] = None,
    licenseInfo: Option[LicenseInfo] = None,
    compatibleArchitectures: Option[
      Iterable[zio.aws.lambda.model.Architecture]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse = {
    import PublishLayerVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse
      .builder()
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .optionallyWith(
        layerArn.map(value => LayerArn.unwrap(value): java.lang.String)
      )(_.layerArn)
      .optionallyWith(
        layerVersionArn.map(value =>
          LayerVersionArn.unwrap(value): java.lang.String
        )
      )(_.layerVersionArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        version.map(value => LayerVersionNumber.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleRuntimesWithStrings)
      .optionallyWith(
        licenseInfo.map(value => LicenseInfo.unwrap(value): java.lang.String)
      )(_.licenseInfo)
      .optionallyWith(
        compatibleArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleArchitecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly =
    zio.aws.lambda.model.PublishLayerVersionResponse.wrap(buildAwsValue())
}
object PublishLayerVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PublishLayerVersionResponse =
      zio.aws.lambda.model.PublishLayerVersionResponse(
        content.map(value => value.asEditable),
        layerArn.map(value => value),
        layerVersionArn.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        version.map(value => value),
        compatibleRuntimes.map(value => value),
        licenseInfo.map(value => value),
        compatibleArchitectures.map(value => value)
      )
    def content: Option[zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly]
    def layerArn: Option[LayerArn]
    def layerVersionArn: Option[LayerVersionArn]
    def description: Option[Description]
    def createdDate: Option[Timestamp]
    def version: Option[LayerVersionNumber]
    def compatibleRuntimes: Option[List[zio.aws.lambda.model.Runtime]]
    def licenseInfo: Option[LicenseInfo]
    def compatibleArchitectures: Option[List[zio.aws.lambda.model.Architecture]]
    def getContent: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly
    ] = AwsError.unwrapOptionField("content", content)
    def getLayerArn: ZIO[Any, AwsError, LayerArn] =
      AwsError.unwrapOptionField("layerArn", layerArn)
    def getLayerVersionArn: ZIO[Any, AwsError, LayerVersionArn] =
      AwsError.unwrapOptionField("layerVersionArn", layerVersionArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getVersion: ZIO[Any, AwsError, LayerVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getCompatibleRuntimes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Runtime]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getLicenseInfo: ZIO[Any, AwsError, LicenseInfo] =
      AwsError.unwrapOptionField("licenseInfo", licenseInfo)
    def getCompatibleArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] = AwsError
      .unwrapOptionField("compatibleArchitectures", compatibleArchitectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse
  ) extends zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly {
    override val content
        : Option[zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly] =
      scala
        .Option(impl.content())
        .map(value =>
          zio.aws.lambda.model.LayerVersionContentOutput.wrap(value)
        )
    override val layerArn: Option[LayerArn] = scala
      .Option(impl.layerArn())
      .map(value => zio.aws.lambda.model.primitives.LayerArn(value))
    override val layerVersionArn: Option[LayerVersionArn] = scala
      .Option(impl.layerVersionArn())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionArn(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
    override val version: Option[LayerVersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionNumber(value))
    override val compatibleRuntimes
        : Option[List[zio.aws.lambda.model.Runtime]] = scala
      .Option(impl.compatibleRuntimes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Runtime.wrap(item)
        }.toList
      )
    override val licenseInfo: Option[LicenseInfo] = scala
      .Option(impl.licenseInfo())
      .map(value => zio.aws.lambda.model.primitives.LicenseInfo(value))
    override val compatibleArchitectures
        : Option[List[zio.aws.lambda.model.Architecture]] = scala
      .Option(impl.compatibleArchitectures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Architecture.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse
  ): zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
