package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEventSourceMappingsResponse(
    nextMarker: Option[String] = None,
    eventSourceMappings: Option[
      Iterable[zio.aws.lambda.model.EventSourceMappingConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse = {
    import ListEventSourceMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        eventSourceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventSourceMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly =
    zio.aws.lambda.model.ListEventSourceMappingsResponse.wrap(buildAwsValue())
}
object ListEventSourceMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListEventSourceMappingsResponse =
      zio.aws.lambda.model.ListEventSourceMappingsResponse(
        nextMarker.map(value => value),
        eventSourceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def eventSourceMappings: Option[
      List[zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getEventSourceMappings: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("eventSourceMappings", eventSourceMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse
  ) extends zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val eventSourceMappings: Option[
      List[zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly]
    ] = scala
      .Option(impl.eventSourceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.EventSourceMappingConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse
  ): zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
