package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Weight, AdditionalVersion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AliasRoutingConfiguration(
    additionalVersionWeights: Option[Map[AdditionalVersion, Weight]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration = {
    import AliasRoutingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration
      .builder()
      .optionallyWith(
        additionalVersionWeights.map(value =>
          value
            .map({ case (key, value) =>
              (AdditionalVersion.unwrap(key): java.lang.String) -> (Weight
                .unwrap(value): java.lang.Double)
            })
            .asJava
        )
      )(_.additionalVersionWeights)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly =
    zio.aws.lambda.model.AliasRoutingConfiguration.wrap(buildAwsValue())
}
object AliasRoutingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AliasRoutingConfiguration =
      zio.aws.lambda.model
        .AliasRoutingConfiguration(additionalVersionWeights.map(value => value))
    def additionalVersionWeights: Option[Map[AdditionalVersion, Weight]]
    def getAdditionalVersionWeights
        : ZIO[Any, AwsError, Map[AdditionalVersion, Weight]] = AwsError
      .unwrapOptionField("additionalVersionWeights", additionalVersionWeights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration
  ) extends zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly {
    override val additionalVersionWeights
        : Option[Map[AdditionalVersion, Weight]] = scala
      .Option(impl.additionalVersionWeights())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives.AdditionalVersion(
              key
            ) -> zio.aws.lambda.model.primitives.Weight(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration
  ): zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly = new Wrapper(impl)
}
