package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  Timeout,
  RoleArn,
  StateReason,
  NameSpacedFunctionArn,
  KMSKeyArn,
  Timestamp,
  MemorySize,
  NamespacedFunctionName,
  Arn,
  Description,
  Version,
  FunctionArn,
  LastUpdateStatusReason,
  Handler
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFunctionCodeResponse(
    functionName: Option[NamespacedFunctionName] = None,
    functionArn: Option[NameSpacedFunctionArn] = None,
    runtime: Option[zio.aws.lambda.model.Runtime] = None,
    role: Option[RoleArn] = None,
    handler: Option[Handler] = None,
    codeSize: Option[Long] = None,
    description: Option[Description] = None,
    timeout: Option[Timeout] = None,
    memorySize: Option[MemorySize] = None,
    lastModified: Option[Timestamp] = None,
    codeSha256: Option[String] = None,
    version: Option[Version] = None,
    vpcConfig: Option[zio.aws.lambda.model.VpcConfigResponse] = None,
    deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig] = None,
    environment: Option[zio.aws.lambda.model.EnvironmentResponse] = None,
    kmsKeyArn: Option[KMSKeyArn] = None,
    tracingConfig: Option[zio.aws.lambda.model.TracingConfigResponse] = None,
    masterArn: Option[FunctionArn] = None,
    revisionId: Option[String] = None,
    layers: Option[Iterable[zio.aws.lambda.model.Layer]] = None,
    state: Option[zio.aws.lambda.model.State] = None,
    stateReason: Option[StateReason] = None,
    stateReasonCode: Option[zio.aws.lambda.model.StateReasonCode] = None,
    lastUpdateStatus: Option[zio.aws.lambda.model.LastUpdateStatus] = None,
    lastUpdateStatusReason: Option[LastUpdateStatusReason] = None,
    lastUpdateStatusReasonCode: Option[
      zio.aws.lambda.model.LastUpdateStatusReasonCode
    ] = None,
    fileSystemConfigs: Option[Iterable[zio.aws.lambda.model.FileSystemConfig]] =
      None,
    packageType: Option[zio.aws.lambda.model.PackageType] = None,
    imageConfigResponse: Option[zio.aws.lambda.model.ImageConfigResponse] =
      None,
    signingProfileVersionArn: Option[Arn] = None,
    signingJobArn: Option[Arn] = None,
    architectures: Option[Iterable[zio.aws.lambda.model.Architecture]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse = {
    import UpdateFunctionCodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse
      .builder()
      .optionallyWith(
        functionName.map(value =>
          NamespacedFunctionName.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        functionArn.map(value =>
          NameSpacedFunctionArn.unwrap(value): java.lang.String
        )
      )(_.functionArn)
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .optionallyWith(
        role.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        handler.map(value => Handler.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.lastModified)
      .optionallyWith(codeSha256.map(value => value: java.lang.String))(
        _.codeSha256
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(
        masterArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.masterArn)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(stateReasonCode.map(value => value.unwrap))(
        _.stateReasonCode
      )
      .optionallyWith(lastUpdateStatus.map(value => value.unwrap))(
        _.lastUpdateStatus
      )
      .optionallyWith(
        lastUpdateStatusReason.map(value =>
          LastUpdateStatusReason.unwrap(value): java.lang.String
        )
      )(_.lastUpdateStatusReason)
      .optionallyWith(lastUpdateStatusReasonCode.map(value => value.unwrap))(
        _.lastUpdateStatusReasonCode
      )
      .optionallyWith(
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemConfigs)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(imageConfigResponse.map(value => value.buildAwsValue()))(
        _.imageConfigResponse
      )
      .optionallyWith(
        signingProfileVersionArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.signingProfileVersionArn)
      .optionallyWith(
        signingJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signingJobArn)
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly =
    zio.aws.lambda.model.UpdateFunctionCodeResponse.wrap(buildAwsValue())
}
object UpdateFunctionCodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateFunctionCodeResponse =
      zio.aws.lambda.model.UpdateFunctionCodeResponse(
        functionName.map(value => value),
        functionArn.map(value => value),
        runtime.map(value => value),
        role.map(value => value),
        handler.map(value => value),
        codeSize.map(value => value),
        description.map(value => value),
        timeout.map(value => value),
        memorySize.map(value => value),
        lastModified.map(value => value),
        codeSha256.map(value => value),
        version.map(value => value),
        vpcConfig.map(value => value.asEditable),
        deadLetterConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        kmsKeyArn.map(value => value),
        tracingConfig.map(value => value.asEditable),
        masterArn.map(value => value),
        revisionId.map(value => value),
        layers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value),
        stateReason.map(value => value),
        stateReasonCode.map(value => value),
        lastUpdateStatus.map(value => value),
        lastUpdateStatusReason.map(value => value),
        lastUpdateStatusReasonCode.map(value => value),
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        packageType.map(value => value),
        imageConfigResponse.map(value => value.asEditable),
        signingProfileVersionArn.map(value => value),
        signingJobArn.map(value => value),
        architectures.map(value => value)
      )
    def functionName: Option[NamespacedFunctionName]
    def functionArn: Option[NameSpacedFunctionArn]
    def runtime: Option[zio.aws.lambda.model.Runtime]
    def role: Option[RoleArn]
    def handler: Option[Handler]
    def codeSize: Option[Long]
    def description: Option[Description]
    def timeout: Option[Timeout]
    def memorySize: Option[MemorySize]
    def lastModified: Option[Timestamp]
    def codeSha256: Option[String]
    def version: Option[Version]
    def vpcConfig: Option[zio.aws.lambda.model.VpcConfigResponse.ReadOnly]
    def deadLetterConfig: Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly]
    def environment: Option[zio.aws.lambda.model.EnvironmentResponse.ReadOnly]
    def kmsKeyArn: Option[KMSKeyArn]
    def tracingConfig
        : Option[zio.aws.lambda.model.TracingConfigResponse.ReadOnly]
    def masterArn: Option[FunctionArn]
    def revisionId: Option[String]
    def layers: Option[List[zio.aws.lambda.model.Layer.ReadOnly]]
    def state: Option[zio.aws.lambda.model.State]
    def stateReason: Option[StateReason]
    def stateReasonCode: Option[zio.aws.lambda.model.StateReasonCode]
    def lastUpdateStatus: Option[zio.aws.lambda.model.LastUpdateStatus]
    def lastUpdateStatusReason: Option[LastUpdateStatusReason]
    def lastUpdateStatusReasonCode
        : Option[zio.aws.lambda.model.LastUpdateStatusReasonCode]
    def fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]]
    def packageType: Option[zio.aws.lambda.model.PackageType]
    def imageConfigResponse
        : Option[zio.aws.lambda.model.ImageConfigResponse.ReadOnly]
    def signingProfileVersionArn: Option[Arn]
    def signingJobArn: Option[Arn]
    def architectures: Option[List[zio.aws.lambda.model.Architecture]]
    def getFunctionName: ZIO[Any, AwsError, NamespacedFunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getFunctionArn: ZIO[Any, AwsError, NameSpacedFunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("role", role)
    def getHandler: ZIO[Any, AwsError, Handler] =
      AwsError.unwrapOptionField("handler", handler)
    def getCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getCodeSha256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.VpcConfigResponse.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getDeadLetterConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.EnvironmentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTracingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.TracingConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getMasterArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("masterArn", masterArn)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getLayers
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Layer.ReadOnly]] =
      AwsError.unwrapOptionField("layers", layers)
    def getState: ZIO[Any, AwsError, zio.aws.lambda.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonCode
        : ZIO[Any, AwsError, zio.aws.lambda.model.StateReasonCode] =
      AwsError.unwrapOptionField("stateReasonCode", stateReasonCode)
    def getLastUpdateStatus
        : ZIO[Any, AwsError, zio.aws.lambda.model.LastUpdateStatus] =
      AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
    def getLastUpdateStatusReason: ZIO[Any, AwsError, LastUpdateStatusReason] =
      AwsError.unwrapOptionField(
        "lastUpdateStatusReason",
        lastUpdateStatusReason
      )
    def getLastUpdateStatusReasonCode
        : ZIO[Any, AwsError, zio.aws.lambda.model.LastUpdateStatusReasonCode] =
      AwsError.unwrapOptionField(
        "lastUpdateStatusReasonCode",
        lastUpdateStatusReasonCode
      )
    def getFileSystemConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FileSystemConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemConfigs", fileSystemConfigs)
    def getPackageType: ZIO[Any, AwsError, zio.aws.lambda.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getImageConfigResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.ImageConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfigResponse", imageConfigResponse)
    def getSigningProfileVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("signingProfileVersionArn", signingProfileVersionArn)
    def getSigningJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signingJobArn", signingJobArn)
    def getArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] =
      AwsError.unwrapOptionField("architectures", architectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse
  ) extends zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly {
    override val functionName: Option[NamespacedFunctionName] = scala
      .Option(impl.functionName())
      .map(value =>
        zio.aws.lambda.model.primitives.NamespacedFunctionName(value)
      )
    override val functionArn: Option[NameSpacedFunctionArn] = scala
      .Option(impl.functionArn())
      .map(value =>
        zio.aws.lambda.model.primitives.NameSpacedFunctionArn(value)
      )
    override val runtime: Option[zio.aws.lambda.model.Runtime] = scala
      .Option(impl.runtime())
      .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val role: Option[RoleArn] = scala
      .Option(impl.role())
      .map(value => zio.aws.lambda.model.primitives.RoleArn(value))
    override val handler: Option[Handler] = scala
      .Option(impl.handler())
      .map(value => zio.aws.lambda.model.primitives.Handler(value))
    override val codeSize: Option[Long] =
      scala.Option(impl.codeSize()).map(value => value: Long)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val timeout: Option[Timeout] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.lambda.model.primitives.Timeout(value))
    override val memorySize: Option[MemorySize] = scala
      .Option(impl.memorySize())
      .map(value => zio.aws.lambda.model.primitives.MemorySize(value))
    override val lastModified: Option[Timestamp] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
    override val codeSha256: Option[String] =
      scala.Option(impl.codeSha256()).map(value => value: String)
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val vpcConfig
        : Option[zio.aws.lambda.model.VpcConfigResponse.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.lambda.model.VpcConfigResponse.wrap(value))
    override val deadLetterConfig
        : Option[zio.aws.lambda.model.DeadLetterConfig.ReadOnly] = scala
      .Option(impl.deadLetterConfig())
      .map(value => zio.aws.lambda.model.DeadLetterConfig.wrap(value))
    override val environment
        : Option[zio.aws.lambda.model.EnvironmentResponse.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.lambda.model.EnvironmentResponse.wrap(value))
    override val kmsKeyArn: Option[KMSKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.lambda.model.primitives.KMSKeyArn(value))
    override val tracingConfig
        : Option[zio.aws.lambda.model.TracingConfigResponse.ReadOnly] = scala
      .Option(impl.tracingConfig())
      .map(value => zio.aws.lambda.model.TracingConfigResponse.wrap(value))
    override val masterArn: Option[FunctionArn] = scala
      .Option(impl.masterArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
    override val layers: Option[List[zio.aws.lambda.model.Layer.ReadOnly]] =
      scala
        .Option(impl.layers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Layer.wrap(item)
          }.toList
        )
    override val state: Option[zio.aws.lambda.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.lambda.model.State.wrap(value))
    override val stateReason: Option[StateReason] = scala
      .Option(impl.stateReason())
      .map(value => zio.aws.lambda.model.primitives.StateReason(value))
    override val stateReasonCode: Option[zio.aws.lambda.model.StateReasonCode] =
      scala
        .Option(impl.stateReasonCode())
        .map(value => zio.aws.lambda.model.StateReasonCode.wrap(value))
    override val lastUpdateStatus
        : Option[zio.aws.lambda.model.LastUpdateStatus] = scala
      .Option(impl.lastUpdateStatus())
      .map(value => zio.aws.lambda.model.LastUpdateStatus.wrap(value))
    override val lastUpdateStatusReason: Option[LastUpdateStatusReason] = scala
      .Option(impl.lastUpdateStatusReason())
      .map(value =>
        zio.aws.lambda.model.primitives.LastUpdateStatusReason(value)
      )
    override val lastUpdateStatusReasonCode
        : Option[zio.aws.lambda.model.LastUpdateStatusReasonCode] = scala
      .Option(impl.lastUpdateStatusReasonCode())
      .map(value => zio.aws.lambda.model.LastUpdateStatusReasonCode.wrap(value))
    override val fileSystemConfigs
        : Option[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]] = scala
      .Option(impl.fileSystemConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FileSystemConfig.wrap(item)
        }.toList
      )
    override val packageType: Option[zio.aws.lambda.model.PackageType] = scala
      .Option(impl.packageType())
      .map(value => zio.aws.lambda.model.PackageType.wrap(value))
    override val imageConfigResponse
        : Option[zio.aws.lambda.model.ImageConfigResponse.ReadOnly] = scala
      .Option(impl.imageConfigResponse())
      .map(value => zio.aws.lambda.model.ImageConfigResponse.wrap(value))
    override val signingProfileVersionArn: Option[Arn] = scala
      .Option(impl.signingProfileVersionArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val signingJobArn: Option[Arn] = scala
      .Option(impl.signingJobArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val architectures
        : Option[List[zio.aws.lambda.model.Architecture]] = scala
      .Option(impl.architectures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Architecture.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse
  ): zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
