package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{MaxListItems, FunctionName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEventSourceMappingsRequest(
    eventSourceArn: Option[Arn] = None,
    functionName: Option[FunctionName] = None,
    marker: Option[String] = None,
    maxItems: Option[MaxListItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest = {
    import ListEventSourceMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest
      .builder()
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(
        functionName.map(value => FunctionName.unwrap(value): java.lang.String)
      )(_.functionName)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListEventSourceMappingsRequest.ReadOnly =
    zio.aws.lambda.model.ListEventSourceMappingsRequest.wrap(buildAwsValue())
}
object ListEventSourceMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListEventSourceMappingsRequest =
      zio.aws.lambda.model.ListEventSourceMappingsRequest(
        eventSourceArn.map(value => value),
        functionName.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def eventSourceArn: Option[Arn]
    def functionName: Option[FunctionName]
    def marker: Option[String]
    def maxItems: Option[MaxListItems]
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getFunctionName: ZIO[Any, AwsError, FunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest
  ) extends zio.aws.lambda.model.ListEventSourceMappingsRequest.ReadOnly {
    override val eventSourceArn: Option[Arn] = scala
      .Option(impl.eventSourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val functionName: Option[FunctionName] = scala
      .Option(impl.functionName())
      .map(value => zio.aws.lambda.model.primitives.FunctionName(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest
  ): zio.aws.lambda.model.ListEventSourceMappingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
