package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DestinationConfig(
    onSuccess: Option[zio.aws.lambda.model.OnSuccess] = None,
    onFailure: Option[zio.aws.lambda.model.OnFailure] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DestinationConfig = {
    import DestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DestinationConfig
      .builder()
      .optionallyWith(onSuccess.map(value => value.buildAwsValue()))(
        _.onSuccess
      )
      .optionallyWith(onFailure.map(value => value.buildAwsValue()))(
        _.onFailure
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DestinationConfig.ReadOnly =
    zio.aws.lambda.model.DestinationConfig.wrap(buildAwsValue())
}
object DestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DestinationConfig =
      zio.aws.lambda.model.DestinationConfig(
        onSuccess.map(value => value.asEditable),
        onFailure.map(value => value.asEditable)
      )
    def onSuccess: Option[zio.aws.lambda.model.OnSuccess.ReadOnly]
    def onFailure: Option[zio.aws.lambda.model.OnFailure.ReadOnly]
    def getOnSuccess
        : ZIO[Any, AwsError, zio.aws.lambda.model.OnSuccess.ReadOnly] =
      AwsError.unwrapOptionField("onSuccess", onSuccess)
    def getOnFailure
        : ZIO[Any, AwsError, zio.aws.lambda.model.OnFailure.ReadOnly] =
      AwsError.unwrapOptionField("onFailure", onFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DestinationConfig
  ) extends zio.aws.lambda.model.DestinationConfig.ReadOnly {
    override val onSuccess: Option[zio.aws.lambda.model.OnSuccess.ReadOnly] =
      scala
        .Option(impl.onSuccess())
        .map(value => zio.aws.lambda.model.OnSuccess.wrap(value))
    override val onFailure: Option[zio.aws.lambda.model.OnFailure.ReadOnly] =
      scala
        .Option(impl.onFailure())
        .map(value => zio.aws.lambda.model.OnFailure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DestinationConfig
  ): zio.aws.lambda.model.DestinationConfig.ReadOnly = new Wrapper(impl)
}
