package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  CatalogIdString,
  SearchPageSize,
  Token
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchTablesByLfTagsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[SearchPageSize] = Optional.Absent,
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    expression: Iterable[zio.aws.lakeformation.model.LFTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest = {
    import SearchTablesByLfTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SearchPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.SearchTablesByLfTagsRequest.ReadOnly =
    zio.aws.lakeformation.model.SearchTablesByLfTagsRequest
      .wrap(buildAwsValue())
}
object SearchTablesByLfTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.SearchTablesByLfTagsRequest =
      zio.aws.lakeformation.model.SearchTablesByLfTagsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        catalogId.map(value => value),
        expression.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[SearchPageSize]
    def catalogId: Optional[CatalogIdString]
    def expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SearchPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest
  ) extends zio.aws.lakeformation.model.SearchTablesByLfTagsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Optional[SearchPageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.lakeformation.model.primitives.SearchPageSize(value)
      )
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.LFTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest
  ): zio.aws.lakeformation.model.SearchTablesByLfTagsRequest.ReadOnly =
    new Wrapper(impl)
}
