package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  TokenString,
  Timestamp,
  TransactionIdString,
  PredicateString,
  NameString,
  PageSize,
  CatalogIdString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTableObjectsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: NameString,
    tableName: NameString,
    transactionId: Optional[TransactionIdString] = Optional.Absent,
    queryAsOfTime: Optional[Timestamp] = Optional.Absent,
    partitionPredicate: Optional[PredicateString] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[TokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest = {
    import GetTableObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .optionallyWith(
        queryAsOfTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.queryAsOfTime)
      .optionallyWith(
        partitionPredicate.map(value =>
          PredicateString.unwrap(value): java.lang.String
        )
      )(_.partitionPredicate)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetTableObjectsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetTableObjectsRequest.wrap(buildAwsValue())
}
object GetTableObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetTableObjectsRequest =
      zio.aws.lakeformation.model.GetTableObjectsRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        transactionId.map(value => value),
        queryAsOfTime.map(value => value),
        partitionPredicate.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def transactionId: Optional[TransactionIdString]
    def queryAsOfTime: Optional[Timestamp]
    def partitionPredicate: Optional[PredicateString]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[TokenString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getQueryAsOfTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("queryAsOfTime", queryAsOfTime)
    def getPartitionPredicate: ZIO[Any, AwsError, PredicateString] =
      AwsError.unwrapOptionField("partitionPredicate", partitionPredicate)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest
  ) extends zio.aws.lakeformation.model.GetTableObjectsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val transactionId: Optional[TransactionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.TransactionIdString(value)
        )
    override val queryAsOfTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.queryAsOfTime())
      .map(value => zio.aws.lakeformation.model.primitives.Timestamp(value))
    override val partitionPredicate: Optional[PredicateString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionPredicate())
        .map(value =>
          zio.aws.lakeformation.model.primitives.PredicateString(value)
        )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Optional[TokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest
  ): zio.aws.lakeformation.model.GetTableObjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
