package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  KeyString,
  ParametersMapValue,
  NameString,
  NullableBoolean,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class DataLakeSettings(
    dataLakeAdmins: Optional[
      Iterable[zio.aws.lakeformation.model.DataLakePrincipal]
    ] = Optional.Absent,
    createDatabaseDefaultPermissions: Optional[
      Iterable[zio.aws.lakeformation.model.PrincipalPermissions]
    ] = Optional.Absent,
    createTableDefaultPermissions: Optional[
      Iterable[zio.aws.lakeformation.model.PrincipalPermissions]
    ] = Optional.Absent,
    parameters: Optional[Map[KeyString, ParametersMapValue]] = Optional.Absent,
    trustedResourceOwners: Optional[Iterable[CatalogIdString]] =
      Optional.Absent,
    allowExternalDataFiltering: Optional[NullableBoolean] = Optional.Absent,
    externalDataFilteringAllowList: Optional[
      Iterable[zio.aws.lakeformation.model.DataLakePrincipal]
    ] = Optional.Absent,
    authorizedSessionTagValueList: Optional[Iterable[NameString]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataLakeSettings = {
    import DataLakeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
      .builder()
      .optionallyWith(
        dataLakeAdmins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataLakeAdmins)
      .optionallyWith(
        createDatabaseDefaultPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createDatabaseDefaultPermissions)
      .optionallyWith(
        createTableDefaultPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createTableDefaultPermissions)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        trustedResourceOwners.map(value =>
          value.map { item =>
            CatalogIdString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustedResourceOwners)
      .optionallyWith(
        allowExternalDataFiltering.map(value => value: java.lang.Boolean)
      )(_.allowExternalDataFiltering)
      .optionallyWith(
        externalDataFilteringAllowList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.externalDataFilteringAllowList)
      .optionallyWith(
        authorizedSessionTagValueList.map(value =>
          value.map { item =>
            NameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authorizedSessionTagValueList)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataLakeSettings.ReadOnly =
    zio.aws.lakeformation.model.DataLakeSettings.wrap(buildAwsValue())
}
object DataLakeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataLakeSettings =
      zio.aws.lakeformation.model.DataLakeSettings(
        dataLakeAdmins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDatabaseDefaultPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTableDefaultPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameters.map(value => value),
        trustedResourceOwners.map(value => value),
        allowExternalDataFiltering.map(value => value),
        externalDataFilteringAllowList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authorizedSessionTagValueList.map(value => value)
      )
    def dataLakeAdmins
        : Optional[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]]
    def createDatabaseDefaultPermissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ]
    def createTableDefaultPermissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ]
    def parameters: Optional[Map[KeyString, ParametersMapValue]]
    def trustedResourceOwners: Optional[List[CatalogIdString]]
    def allowExternalDataFiltering: Optional[NullableBoolean]
    def externalDataFilteringAllowList
        : Optional[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]]
    def authorizedSessionTagValueList: Optional[List[NameString]]
    def getDataLakeAdmins: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField("dataLakeAdmins", dataLakeAdmins)
    def getCreateDatabaseDefaultPermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createDatabaseDefaultPermissions",
      createDatabaseDefaultPermissions
    )
    def getCreateTableDefaultPermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createTableDefaultPermissions",
      createTableDefaultPermissions
    )
    def getParameters: ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getTrustedResourceOwners: ZIO[Any, AwsError, List[CatalogIdString]] =
      AwsError.unwrapOptionField("trustedResourceOwners", trustedResourceOwners)
    def getAllowExternalDataFiltering: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "allowExternalDataFiltering",
        allowExternalDataFiltering
      )
    def getExternalDataFilteringAllowList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "externalDataFilteringAllowList",
      externalDataFilteringAllowList
    )
    def getAuthorizedSessionTagValueList: ZIO[Any, AwsError, List[NameString]] =
      AwsError.unwrapOptionField(
        "authorizedSessionTagValueList",
        authorizedSessionTagValueList
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ) extends zio.aws.lakeformation.model.DataLakeSettings.ReadOnly {
    override val dataLakeAdmins: Optional[
      List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataLakeAdmins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.DataLakePrincipal.wrap(item)
        }.toList
      )
    override val createDatabaseDefaultPermissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createDatabaseDefaultPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalPermissions.wrap(item)
        }.toList
      )
    override val createTableDefaultPermissions: Optional[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createTableDefaultPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalPermissions.wrap(item)
        }.toList
      )
    override val parameters: Optional[Map[KeyString, ParametersMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lakeformation.model.primitives
                .KeyString(key) -> zio.aws.lakeformation.model.primitives
                .ParametersMapValue(value)
            })
            .toMap
        )
    override val trustedResourceOwners: Optional[List[CatalogIdString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustedResourceOwners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.CatalogIdString(item)
          }.toList
        )
    override val allowExternalDataFiltering: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowExternalDataFiltering())
        .map(value => value: NullableBoolean)
    override val externalDataFilteringAllowList: Optional[
      List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.externalDataFilteringAllowList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.DataLakePrincipal.wrap(item)
        }.toList
      )
    override val authorizedSessionTagValueList: Optional[List[NameString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizedSessionTagValueList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.NameString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ): zio.aws.lakeformation.model.DataLakeSettings.ReadOnly = new Wrapper(impl)
}
