package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.ComparisonOperator
  ): zio.aws.lakeformation.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.NE =>
      val r = NE
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.LE =>
      val r = LE
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.LT =>
      val r = LT
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.GT =>
      val r = GT
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.NOT_CONTAINS =>
      val r = NOT_CONTAINS
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.BEGINS_WITH =>
      val r = BEGINS_WITH
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.IN =>
      val r = IN
      r
    case software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.BETWEEN =>
      val r = BETWEEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.EQ
  }
  case object NE extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.NE
  }
  case object LE extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.LE
  }
  case object LT extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.LT
  }
  case object GE extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.GE
  }
  case object GT extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.GT
  }
  case object CONTAINS extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.CONTAINS
  }
  case object NOT_CONTAINS
      extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.NOT_CONTAINS
  }
  case object BEGINS_WITH
      extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.BEGINS_WITH
  }
  case object IN extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.IN
  }
  case object BETWEEN extends zio.aws.lakeformation.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.ComparisonOperator =
      software.amazon.awssdk.services.lakeformation.model.ComparisonOperator.BETWEEN
  }
}
