package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{Timestamp, TransactionIdString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TransactionDescription(
    transactionId: Optional[TransactionIdString] = Optional.Absent,
    transactionStatus: Optional[zio.aws.lakeformation.model.TransactionStatus] =
      Optional.Absent,
    transactionStartTime: Optional[Timestamp] = Optional.Absent,
    transactionEndTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TransactionDescription = {
    import TransactionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TransactionDescription
      .builder()
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .optionallyWith(transactionStatus.map(value => value.unwrap))(
        _.transactionStatus
      )
      .optionallyWith(
        transactionStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transactionStartTime)
      .optionallyWith(
        transactionEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transactionEndTime)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TransactionDescription.ReadOnly =
    zio.aws.lakeformation.model.TransactionDescription.wrap(buildAwsValue())
}
object TransactionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TransactionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TransactionDescription =
      zio.aws.lakeformation.model.TransactionDescription(
        transactionId.map(value => value),
        transactionStatus.map(value => value),
        transactionStartTime.map(value => value),
        transactionEndTime.map(value => value)
      )
    def transactionId: Optional[TransactionIdString]
    def transactionStatus
        : Optional[zio.aws.lakeformation.model.TransactionStatus]
    def transactionStartTime: Optional[Timestamp]
    def transactionEndTime: Optional[Timestamp]
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getTransactionStatus
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.TransactionStatus] =
      AwsError.unwrapOptionField("transactionStatus", transactionStatus)
    def getTransactionStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transactionStartTime", transactionStartTime)
    def getTransactionEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transactionEndTime", transactionEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TransactionDescription
  ) extends zio.aws.lakeformation.model.TransactionDescription.ReadOnly {
    override val transactionId: Optional[TransactionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.TransactionIdString(value)
        )
    override val transactionStatus
        : Optional[zio.aws.lakeformation.model.TransactionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionStatus())
        .map(value => zio.aws.lakeformation.model.TransactionStatus.wrap(value))
    override val transactionStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionStartTime())
        .map(value => zio.aws.lakeformation.model.primitives.Timestamp(value))
    override val transactionEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionEndTime())
      .map(value => zio.aws.lakeformation.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TransactionDescription
  ): zio.aws.lakeformation.model.TransactionDescription.ReadOnly = new Wrapper(
    impl
  )
}
