package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class SearchDatabasesByLfTagsResponse(
    nextToken: Optional[Token] = Optional.Absent,
    databaseList: Optional[
      Iterable[zio.aws.lakeformation.model.TaggedDatabase]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse = {
    import SearchDatabasesByLfTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        databaseList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseList)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly =
    zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse
      .wrap(buildAwsValue())
}
object SearchDatabasesByLfTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse =
      zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse(
        nextToken.map(value => value),
        databaseList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def databaseList
        : Optional[List[zio.aws.lakeformation.model.TaggedDatabase.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDatabaseList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.TaggedDatabase.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseList", databaseList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse
  ) extends zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val databaseList
        : Optional[List[zio.aws.lakeformation.model.TaggedDatabase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.TaggedDatabase.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse
  ): zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly =
    new Wrapper(impl)
}
