package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.TokenString
import scala.jdk.CollectionConverters._
final case class GetTableObjectsResponse(
    objects: Optional[Iterable[zio.aws.lakeformation.model.PartitionObjects]] =
      Optional.Absent,
    nextToken: Optional[TokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse = {
    import GetTableObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse
      .builder()
      .optionallyWith(
        objects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.objects)
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetTableObjectsResponse.wrap(buildAwsValue())
}
object GetTableObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetTableObjectsResponse =
      zio.aws.lakeformation.model.GetTableObjectsResponse(
        objects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def objects
        : Optional[List[zio.aws.lakeformation.model.PartitionObjects.ReadOnly]]
    def nextToken: Optional[TokenString]
    def getObjects: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PartitionObjects.ReadOnly
    ]] = AwsError.unwrapOptionField("objects", objects)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse
  ) extends zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly {
    override val objects: Optional[
      List[zio.aws.lakeformation.model.PartitionObjects.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.objects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PartitionObjects.wrap(item)
        }.toList
      )
    override val nextToken: Optional[TokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse
  ): zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
