package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class GetDataCellsFilterRequest(
    tableCatalogId: CatalogIdString,
    databaseName: NameString,
    tableName: NameString,
    name: NameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest = {
    import GetDataCellsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest
      .builder()
      .tableCatalogId(CatalogIdString.unwrap(tableCatalogId): java.lang.String)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetDataCellsFilterRequest.ReadOnly =
    zio.aws.lakeformation.model.GetDataCellsFilterRequest.wrap(buildAwsValue())
}
object GetDataCellsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetDataCellsFilterRequest =
      zio.aws.lakeformation.model.GetDataCellsFilterRequest(
        tableCatalogId,
        databaseName,
        tableName,
        name
      )
    def tableCatalogId: CatalogIdString
    def databaseName: NameString
    def tableName: NameString
    def name: NameString
    def getTableCatalogId: ZIO[Any, Nothing, CatalogIdString] =
      ZIO.succeed(tableCatalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest
  ) extends zio.aws.lakeformation.model.GetDataCellsFilterRequest.ReadOnly {
    override val tableCatalogId: CatalogIdString =
      zio.aws.lakeformation.model.primitives
        .CatalogIdString(impl.tableCatalogId())
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val name: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest
  ): zio.aws.lakeformation.model.GetDataCellsFilterRequest.ReadOnly =
    new Wrapper(impl)
}
