package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  ResourceArnString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class DataLocationResource(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    resourceArn: ResourceArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataLocationResource = {
    import DataLocationResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataLocationResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataLocationResource.ReadOnly =
    zio.aws.lakeformation.model.DataLocationResource.wrap(buildAwsValue())
}
object DataLocationResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataLocationResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataLocationResource =
      zio.aws.lakeformation.model
        .DataLocationResource(catalogId.map(value => value), resourceArn)
    def catalogId: Optional[CatalogIdString]
    def resourceArn: ResourceArnString
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLocationResource
  ) extends zio.aws.lakeformation.model.DataLocationResource.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLocationResource
  ): zio.aws.lakeformation.model.DataLocationResource.ReadOnly = new Wrapper(
    impl
  )
}
