package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class RevokePermissionsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    principal: zio.aws.lakeformation.model.DataLakePrincipal,
    resource: zio.aws.lakeformation.model.Resource,
    permissions: Iterable[zio.aws.lakeformation.model.Permission],
    permissionsWithGrantOption: Optional[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest = {
    import RevokePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .principal(principal.buildAwsValue())
      .resource(resource.buildAwsValue())
      .permissionsWithStrings(permissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.RevokePermissionsRequest.ReadOnly =
    zio.aws.lakeformation.model.RevokePermissionsRequest.wrap(buildAwsValue())
}
object RevokePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.RevokePermissionsRequest =
      zio.aws.lakeformation.model.RevokePermissionsRequest(
        catalogId.map(value => value),
        principal.asEditable,
        resource.asEditable,
        permissions,
        permissionsWithGrantOption.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def principal: zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    def resource: zio.aws.lakeformation.model.Resource.ReadOnly
    def permissions: List[zio.aws.lakeformation.model.Permission]
    def permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getPrincipal: ZIO[
      Any,
      Nothing,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = ZIO.succeed(principal)
    def getResource
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getPermissions
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.Permission]] =
      ZIO.succeed(permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest
  ) extends zio.aws.lakeformation.model.RevokePermissionsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val principal
        : zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly =
      zio.aws.lakeformation.model.DataLakePrincipal.wrap(impl.principal())
    override val resource: zio.aws.lakeformation.model.Resource.ReadOnly =
      zio.aws.lakeformation.model.Resource.wrap(impl.resource())
    override val permissions: List[zio.aws.lakeformation.model.Permission] =
      impl
        .permissions()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }
        .toList
    override val permissionsWithGrantOption
        : Optional[List[zio.aws.lakeformation.model.Permission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsWithGrantOption())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.Permission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest
  ): zio.aws.lakeformation.model.RevokePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
