package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.PartitionValueString
import scala.jdk.CollectionConverters._
final case class PartitionObjects(
    partitionValues: Optional[Iterable[PartitionValueString]] = Optional.Absent,
    objects: Optional[Iterable[zio.aws.lakeformation.model.TableObject]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PartitionObjects = {
    import PartitionObjects.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PartitionObjects
      .builder()
      .optionallyWith(
        partitionValues.map(value =>
          value.map { item =>
            PartitionValueString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionValues)
      .optionallyWith(
        objects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.objects)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PartitionObjects.ReadOnly =
    zio.aws.lakeformation.model.PartitionObjects.wrap(buildAwsValue())
}
object PartitionObjects {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PartitionObjects
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PartitionObjects =
      zio.aws.lakeformation.model.PartitionObjects(
        partitionValues.map(value => value),
        objects.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def partitionValues: Optional[List[PartitionValueString]]
    def objects
        : Optional[List[zio.aws.lakeformation.model.TableObject.ReadOnly]]
    def getPartitionValues: ZIO[Any, AwsError, List[PartitionValueString]] =
      AwsError.unwrapOptionField("partitionValues", partitionValues)
    def getObjects: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.TableObject.ReadOnly
    ]] = AwsError.unwrapOptionField("objects", objects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PartitionObjects
  ) extends zio.aws.lakeformation.model.PartitionObjects.ReadOnly {
    override val partitionValues: Optional[List[PartitionValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.PartitionValueString(item)
          }.toList
        )
    override val objects
        : Optional[List[zio.aws.lakeformation.model.TableObject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.TableObject.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PartitionObjects
  ): zio.aws.lakeformation.model.PartitionObjects.ReadOnly = new Wrapper(impl)
}
