package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListLfTagsResponse(
    lfTags: Optional[Iterable[zio.aws.lakeformation.model.LFTagPair]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse = {
    import ListLfTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
      .builder()
      .optionallyWith(
        lfTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTags)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly =
    zio.aws.lakeformation.model.ListLfTagsResponse.wrap(buildAwsValue())
}
object ListLfTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListLfTagsResponse =
      zio.aws.lakeformation.model.ListLfTagsResponse(
        lfTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lfTags: Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def nextToken: Optional[Token]
    def getLfTags: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTags", lfTags)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ) extends zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly {
    override val lfTags
        : Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.LFTagPair.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse
  ): zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly = new Wrapper(impl)
}
