package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  ExpirationTimestamp,
  SessionTokenString,
  SecretAccessKeyString,
  AccessKeyIdString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetTemporaryGlueTableCredentialsResponse(
    accessKeyId: Optional[AccessKeyIdString] = Optional.Absent,
    secretAccessKey: Optional[SecretAccessKeyString] = Optional.Absent,
    sessionToken: Optional[SessionTokenString] = Optional.Absent,
    expiration: Optional[ExpirationTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse = {
    import GetTemporaryGlueTableCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
      .builder()
      .optionallyWith(
        accessKeyId.map(value =>
          AccessKeyIdString.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          SecretAccessKeyString.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value =>
          SessionTokenString.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .optionallyWith(
        expiration.map(value => ExpirationTimestamp.unwrap(value): Instant)
      )(_.expiration)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly =
    zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
      .wrap(buildAwsValue())
}
object GetTemporaryGlueTableCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse =
      zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value),
        expiration.map(value => value)
      )
    def accessKeyId: Optional[AccessKeyIdString]
    def secretAccessKey: Optional[SecretAccessKeyString]
    def sessionToken: Optional[SessionTokenString]
    def expiration: Optional[ExpirationTimestamp]
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyIdString] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, SecretAccessKeyString] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, SessionTokenString] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
    def getExpiration: ZIO[Any, AwsError, ExpirationTimestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
  ) extends zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly {
    override val accessKeyId: Optional[AccessKeyIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKeyId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.AccessKeyIdString(value)
        )
    override val secretAccessKey: Optional[SecretAccessKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretAccessKey())
        .map(value =>
          zio.aws.lakeformation.model.primitives.SecretAccessKeyString(value)
        )
    override val sessionToken: Optional[SessionTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionToken())
        .map(value =>
          zio.aws.lakeformation.model.primitives.SessionTokenString(value)
        )
    override val expiration: Optional[ExpirationTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiration())
        .map(value =>
          zio.aws.lakeformation.model.primitives.ExpirationTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse
  ): zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
